procedure $see_results
argument local scalar runnumber 
argument local namelist freqs
argument local string scalar pro_path = ""
argument local string scalar db_path = ""
block

   if (not missing(location("NUMERIC,PRECISION",type(local'runnumber))))
      -local'rno = local'runnumber
      -local'runno = string(local'runnumber)
   else if (type(local'runnumber) eq "STRING")
      -local'runno = trim(local'runnumber)
      -local'rno = number(local'runno)
      if (missing(local'rno))
         signal error: "$see_result: An invalid run number <"+local'runnumber+"> was specified."+ &&
                        NEWLINE+ERRORTEXT
      end if 
   else
      signal error: "$see_result: First argument must be a scalar of type NUMERIC, PRECISION, or STRING"
   end

   freq m; date * to *
   open <ac re> file(local'db_path+"lfpr_run"+string(rno)+".db") as lout
   open <ac re> file(local'db_path+"cpscovar_rev.db") as cpsrev
   $open us

   device graphics postp
   page margins horizontal 0, vertical 0
   plot missing connect

   glue null
   overwrite on

   --------------------------------------------------------------------
   -- PLOT THE AGE AND COHORT PROFILES
   --------------------------------------------------------------------
   cload file(local'pro_path+"see_profiles.pro")
   $see_profiles local'runno, local'freqs, local'db_path

   --------------------------------------------------------------------
   -- PLOT RHS COEFFICIENTS
   --------------------------------------------------------------------
   cload file(local'pro_path+"see_coefficients.pro")
   $see_coefficients local'runno, local'freqs, local'db_path

   --------------------------------------------------------------------
   -- PLOT AR1 PARAMETERS (IF AR ERROR MODEL USED)
   --------------------------------------------------------------------
   if (exists(lout'errmod))
      if ((lout'errmod eq 1) or (lout'errmod eq 2))
         cload file(local'pro_path+"see_ar.pro")
         $see_ar local'runno, local'freqs, local'db_path
      end if
   end if

   --------------------------------------------------------------------
   -- PLOT SOME EXTRA AGE/SEX SPECIFIC INFORMATION
   --------------------------------------------------------------------
   case 1 to *
   local'agelower = list(16,25,16,18,16,20,25,30,35,40,45,50,55,60,62,65,70)
   local'ageupper = list(80,80,17,19,19,24,29,34,39,44,49,54,59,61,64,69,80)

   cload file(local'pro_path+"see_extra.pro")
   $see_extra local'runno, local'freqs, local'agelower, local'ageupper, local'db_path, local'pro_path

   --------------------------------------------------------------------
   -- PLOT AGGREGATE INFORMATION
   --------------------------------------------------------------------
   cload file(local'pro_path+"see_agg.pro")
   $see_agg local'runno, local'freqs, list(16,16,16,25,55,25,16,18,16,20,25,30,35,40,45,50,55,60,62,65,70), &&
                                      list(80,79,24,54,80,80,17,19,19,24,29,34,39,44,49,54,59,61,64,69,80), &&
            local'db_path, local'pro_path

   --------------------------------------------------------------------
   -- PLOT CONTRIBUTIONS
   --------------------------------------------------------------------
   cload file(local'pro_path+"see_contx.pro")
   $see_contx local'runno, local'freqs, local'agelower, local'ageupper, local'db_path

   --------------------------------------------------------------------
   -- PLOT RESIDUALS
   --------------------------------------------------------------------
   cload file(local'pro_path+"see_resids.pro")
   $see_resids local'runno, local'freqs, local'agelower, local'ageupper, local'db_path, local'pro_path


   channel warnings output 

   close all

end block
end procedure

